<META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8">

<?php
include 'config.php'; // Βεβαιώσου ότι είναι στο ίδιο directory

$symb = 74;

// Προετοιμασία SQL ερωτήματος
$stmt = $bd->prepare("SELECT id, ar_symb, dik_ofel, name, afm FROM oaed_thea WHERE ar_symb = ? AND dik_ofel = 2");

if (!$stmt) {
    die("Σφάλμα prepare(): " . $bd->error);
}

$stmt->bind_param('i', $symb);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 0) {
    echo "❌ Δεν βρέθηκαν εγγραφές με ar_symb = $symb και dik_ofel = 2";
    exit;
}

$stmt->bind_result($id, $ar_symb, $dik_ofel, $name, $afm);
while ($stmt->fetch()) {
    echo "✅ Βρέθηκε: $name ($afm), ID: $id<br>";
}

$stmt->close();
?>
<?php
$day = 3;

echo match($day) {
    1 => "Δευτέρα",
    2 => "Τρίτη",
    3 => "Τετάρτη",
    4 => "Πέμπτη",
    5 => "Παρασκευή",
    default => "Άγνωστη μέρα",
};
?>
