<?php
include('config.php');
include('lock.php');

// Ερώτημα για τους δικαιούχους με περίοδο 'b'
$stmt = $bd->prepare("SELECT name, afm, amka, epitagi, date_in, date_out, room, plithos_dom, typos_domatio, idiotita_ex, sxolia 
                      FROM oaed_thea 
                      WHERE periodos = 'a' 
                      ORDER BY date_in ASC, ar_symb ASC, id ASC");
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($name, $afm, $amka, $epitagi, $date_in, $date_out, $room, $plithos_dom, $typos_domatio, $idiotita_ex, $sxolia);
?>

<!DOCTYPE html>
<html lang="el">
<head>
    <meta charset="UTF-8">
    <title>ΟΑΕΔ - Λίστα Δικαιούχων</title>
    <style>
        @media screen {
            #footer_wrapper {
                display: none;
            }
        }

        @media print {
            tfoot { visibility: hidden; }
            #footer_wrapper {
                margin: 0px 2px 0px 7px;
                position: fixed;
                bottom: 0;
            }
            #footer_content {
                font-weight: bold;
            }
        }

        .style1 {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 10px;
            color: #000;
        }

        .style2 {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 11px;
            font-weight: bold;
            color: #333;
        }

        .style8 {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 17px;
            font-weight: bold;
            color: #333;
        }

        @media print {
            #prnBtn, #bck, #related_links {
                display: none;
            }
        }

        table {
            width: 1150px;
            margin: auto;
            border-collapse: collapse;
        }

        table th, table td {
            border: 1px solid black;
            padding: 4px;
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 10px;
        }

        th {
            background-color: #fbfbd3;
        }
    </style>
</head>
<body>

<p align="center"><input type="button" id="prnBtn" value="εκτύπωση" onclick="window.print()"></p>

<table>
    <thead>
        <tr>
            <th colspan="9" class="style8" align="center">
                <p><img src="images/dypa.jpg" width="86" height="48" />&nbsp;&nbsp;&nbsp;
                ΠΡΟΓΡΑΜΜΑ ΕΠΙΔΟΤΗΣΗΣ ΔΙΑΚΟΠΩΝ ΕΡΓΑΖΟΜΕΝΩΝ, ΑΝΕΡΓΩΝ &amp; ΤΩΝ ΟΙΚΟΓΕΝΕΙΩΝ ΑΥΤΩΝ ΜΕ ΕΠΙΤΑΓΗ ΚΟΙΝΩΝΙΚΟΥ ΤΟΥΡΙΣΜΟΥ ΕΤΟΥΣ 2024 - 2025</p>
                <p>ΟΝΟΜΑΣΤΙΚΗ ΚΑΤΑΣΤΑΣΗ ΔΙΚΑΙΟΥΧΩΝ/ΩΦΕΛΟΥΜΕΝΩΝ</p>
            </th>
        </tr>
        <tr class="style2">
            <th>Α/Α</th>
            <th>ΟΝΟΜΑΤΕΠΩΝΥΜΟ</th>
            <th>ΑΦΜ</th>
            <th>ΑΜΚΑ</th>
            <th>ΑΡΙΘΜΟΣ ΕΠΙΤΑΓΗΣ</th>
            <th>ΗΜΕΡΟΜΗΝΙΑ ΑΦΙΞΗΣ</th>
            <th>ΗΜΕΡΟΜΗΝΙΑ ΑΝΑΧΩΡΗΣΗΣ</th>
            <th>ΑΡΙΘΜΟΣ / ΚΑΤΗΓΟΡΙΑ ΔΩΜΑΤΙΟΥ</th>
            <th>ΠΑΡΑΤΗΡΗΣΕΙΣ</th>
        </tr>
    </thead>
    <tbody>
<?php
$counter = 1;
while ($stmt->fetch()):
    $datein = date('d/m/Y', strtotime($date_in));
    $dateout = date('d/m/Y', strtotime($date_out));

    $typos_dom = '';
    switch ($typos_domatio) {
        case '1': $typos_dom = 'ΜΟΝΟΚΛΙΝΟ'; break;
        case '2': $typos_dom = 'ΔΙΚΛΙΝΟ(A)'; break;
        case '3': $typos_dom = 'ΔΙΚΛ+ΚΛΙΝΗ'; break;
    }
?>
        <tr class="style1">
            <td align="center"><?= $counter++ ?></td>
            <td  style="width: 200px; white-space: nowrap;"><?= htmlspecialchars($name) ?></td>
            <td  style="width: 70px; white-space: nowrap;"align="center"><?= htmlspecialchars($afm) ?></td>
            <td  style="width: 90px; white-space: nowrap;"align="center"><?= htmlspecialchars($amka) ?></td>
            <td  style="width: 200px; white-space: nowrap;"  align="center"><?= htmlspecialchars($epitagi) ?></td>
            <td align="center"><?= $datein ?></td>
            <td align="center"><?= $dateout ?></td>
            <td  style="width: 100px; white-space: nowrap;"align="center"><?= htmlspecialchars($room) ?> / <?= htmlspecialchars($plithos_dom) ?> <?= $typos_dom ?></td>
            <td align="center"><?= htmlspecialchars($idiotita_ex) ?> <?= $sxolia ? "- " . htmlspecialchars($sxolia) : "" ?></td>
        </tr>
<?php endwhile; ?>
    </tbody>
</table>

</body>
</html>

<?php
$stmt->close();
$bd->close();
?>
