
<?php
include('config.php');

// Έλεγχος αν το session έχει ήδη ξεκινήσει
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Ελέγχουμε αν υπάρχει το όνομα χρήστη στην συνεδρία
$user_check = isset($_SESSION['login_user']) ? $_SESSION['login_user'] : null;

// Αν δεν υπάρχει το όνομα χρήστη στην συνεδρία, ανακατευθύνουμε στην αρχική σελίδα
if (!$user_check) {
    header("Location: index.php");
    exit;
}

// Προετοιμάζουμε το query για την αναζήτηση του χρήστη στην βάση δεδομένων
$stmt = $bd->prepare("SELECT username FROM admin WHERE username = ?");
$stmt->bind_param("s", $user_check);
$stmt->execute();
$stmt->store_result();

// Αν υπάρχει το username στη βάση, το αποθηκεύουμε
if ($stmt->num_rows === 1) {
    $stmt->bind_result($login_session);
    $stmt->fetch();
} else {
    // Αν δεν βρέθηκε το username, ανακατευθύνουμε στην αρχική σελίδα
    header("Location: index.php");
    exit;
}

// Κλείνουμε το statement
$stmt->close();
?>
