<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include('config.php');

if (!$bd) {
    die("Connection failed: " . mysqli_connect_error());
}

header('Content-Type: text/html; charset=utf-8');
$bd->set_charset("utf8mb4");

// Πίνακας δεδομένων
$data = [
    [
        'ar_symb' => $_POST['ar_symb'],
        'dik_ofel' => $_POST['dik_ofel'],
        'name' => $_POST['name'],
        'katoikos' => $_POST['katoikos'],
        'afm' => $_POST['afm'],
        'amka' => $_POST['amka'],
        'epitagi' => $_POST['epitagi'],
        'room' => $_POST['room'],
        'typos_domatio' => $_POST['typos_domatio'],
        'extra' => null,
        'plithos_dom' => $_POST['plithos_dom'],
        'date_in' => $_POST['date_in'],
        'date_out' => $_POST['date_out'],
        'imeres' => $_POST['imeres'],
        'dianiktere' => $_POST['dianiktere'],
        'epidotisi' => $_POST['epidotisi'],
        'simetoxi' => $_POST['simetoxi'],
        'simf_simetox' => $_POST['simf_simetox'],
        'hotel' => 'thea',
        'periodos' => $_POST['periodos'],
        'ar_ofel' => $_POST['ar_ofel'],
        'sxolia' => isset($_POST['sxolia']) ? $_POST['sxolia'] : '', 
        'onoma_ex' => $_POST['onoma_ex'],
        'im_ex' => $_POST['im_ex'],
        'idiotita_ex' => $_POST['idiotita_ex']
    ],
    [
        'ar_symb' => $_POST['ar_symb'],
        'dik_ofel' => $_POST['dik_ofel2'],
        'name' => $_POST['name4'],
        'katoikos' => $_POST['katoikos'],
        'afm' => '',
        'amka' => $_POST['amka2'],
        'epitagi' => $_POST['epitagi2'],
        'room' => $_POST['room'],
        'typos_domatio' => $_POST['typos_domatio'],
        'extra' => 0,
        'plithos_dom' => $_POST['plithos_dom'],
        'date_in' => $_POST['date_in'],
        'date_out' => $_POST['date_out'],
        'imeres' => $_POST['imeres'],
        'dianiktere' => $_POST['dianiktere'],
        'epidotisi' => $_POST['epidotisi'],
        'simetoxi' => $_POST['simetoxi'],
        'simf_simetox' => $_POST['simf_simetox'],
        'hotel' => 'thea',
        'periodos' => $_POST['periodos'],
        'ar_ofel' => $_POST['ar_ofel'],
        'sxolia' => isset($_POST['sxolia']) ? $_POST['sxolia'] : '',
        'onoma_ex' => $_POST['onoma_ex'],
        'im_ex' => $_POST['im_ex'],
        'idiotita_ex' => $_POST['idiotita_ex']
    ],
    [
        'ar_symb' => $_POST['ar_symb'],
        'dik_ofel' => $_POST['dik_ofel3'],
        'name' => $_POST['name3'],
        'katoikos' => $_POST['katoikos'],
        'afm' => '',
        'amka' => $_POST['amka3'],
        'epitagi' => $_POST['epitagi3'],
        'room' => $_POST['room'],
        'typos_domatio' => $_POST['typos_domatio'],
        'extra' => 0,
        'plithos_dom' => $_POST['plithos_dom'],
        'date_in' => $_POST['date_in'],
        'date_out' => $_POST['date_out'],
        'imeres' => $_POST['imeres'],
        'dianiktere' => $_POST['dianiktere'],
        'epidotisi' => $_POST['epidotisi'],
        'simetoxi' => $_POST['simetoxi'],
        'simf_simetox' => $_POST['simf_simetox'],
        'hotel' => 'thea',
        'periodos' => $_POST['periodos'],
        'ar_ofel' => $_POST['ar_ofel'],
        'sxolia' => isset($_POST['sxolia']) ? $_POST['sxolia'] : '', 
        'onoma_ex' => $_POST['onoma_ex'],
        'im_ex' => $_POST['im_ex'],
        'idiotita_ex' => $_POST['idiotita_ex']
    ]
];

// SQL Query
$sql = "INSERT INTO oaed_thea 
    (ar_symb, dik_ofel, name, katoikos, afm, amka, epitagi, room, typos_domatio, extra, 
    plithos_dom, date_in, date_out, imeres, dianiktere, epidotisi, simetoxi, simf_simetox, hotel, 
    periodos, ar_ofel, sxolia, onoma_ex, im_ex, idiotita_ex) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

// Prepare statement
$stmt = $bd->prepare($sql);
if ($stmt === false) {
    die("SQL preparation failed: " . $bd->error);
}

// Εκτέλεση εισαγωγών
foreach ($data as $row) {
    // Ορισμός μεταβλητών για bind
    $ar_symb = $row['ar_symb'];
    $dik_ofel = $row['dik_ofel'];
    $name = $row['name'];
    $katoikos = $row['katoikos'];
    $afm = $row['afm'];
    $amka = $row['amka'];
    $epitagi = $row['epitagi'];
    $room = $row['room'];
    $typos_domatio = (int)$row['typos_domatio'];
    $extra = is_null($row['extra']) ? 0 : (int)$row['extra'];
    $plithos_dom = $row['plithos_dom'];
    $date_in = $row['date_in'];
    $date_out = $row['date_out'];
    $imeres = $row['imeres'];
    $dianiktere = $row['dianiktere'];
    $epidotisi = (float)$row['epidotisi'];
    $simetoxi = (float)$row['simetoxi'];
    $simf_simetox = (float)$row['simf_simetox'];
    $hotel = $row['hotel'];
    $periodos = $row['periodos'];
    $ar_ofel = $row['ar_ofel'];
    $sxolia = $row['sxolia'];
    $onoma_ex = $row['onoma_ex'];
    $im_ex = $row['im_ex'];
    $idiotita_ex = $row['idiotita_ex'];

    $stmt->bind_param(
        'sssssssissssssdddsissssss',
        $ar_symb, $dik_ofel, $name, $katoikos, $afm, $amka, $epitagi,
        $room, $typos_domatio, $extra, $plithos_dom, $date_in,
        $date_out, $imeres, $dianiktere, $epidotisi, $simetoxi,
        $simf_simetox, $hotel, $periodos, $ar_ofel, $sxolia,
        $onoma_ex, $im_ex, $idiotita_ex
    );

    if (!$stmt->execute()) {
        echo "Σφάλμα εισαγωγής: " . $stmt->error . "<br>";
    }
}

$stmt->close();
$bd->close();

// Επιτυχής ανακατεύθυνση
echo "<meta http-equiv='refresh' content='0; url=http://hotelthea.gr/n_oaed24s/dik_oaed.php'>";
?>
