<?php
include('config.php');
include('lock.php');
include('welcome.php');
include('style.php');

// Έλεγχος αν το session έχει ήδη ξεκινήσει
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Αρχικοποίηση μεταβλητών για σύνολα
$sumepid = 0;
$sumsime = 0;
$sumdiak = 0;

// Ερώτημα για σύνολα
$stmtSum = $bd->prepare("SELECT SUM(epidotisi), SUM(simetoxi), SUM(dianiktere) FROM oaed_thea WHERE periodos = 'A'");
$stmtSum->execute();
$stmtSum->bind_result($sumepid, $sumsime, $sumdiak);
$stmtSum->fetch();
$stmtSum->close();

// Ερώτημα για προβολή δικαιούχων
$stmt = $bd->prepare("SELECT id, name, afm, amka, epitagi, room, date_in, date_out, dianiktere, ar_ofel FROM oaed_thea WHERE dik_ofel = 1 ORDER BY date_in DESC, id DESC");
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($id, $name, $afm, $amka, $epitagi, $room, $date_in, $date_out, $dianiktere, $ar_ofel);
?>

<!DOCTYPE html>
<html lang="el">
<head>
    <meta charset="UTF-8">
    <title>Πίνακας Δικαιούχων</title>
    <style>
        /* Προσαρμοσμένα στυλ */
        .style1 { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; font-weight: bold; color: #333; }
        .style7 { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 22px; font-weight: bold; color: #333; }
        .style4 { font-family: Geneva, Arial, Helvetica, sans-serif; font-size: 14px; font-weight: bold; }
        a { color: #19315E; text-decoration: none; }
        body { background-color: #FFFFFF; }
    </style>
</head>
<body>

<p align="center" style="font-family: Verdana; font-size: 22px; font-weight: bold;">Πίνακας Δικαιούχων</p>
<p align="center" class="style4"><a href="home.php">Επιστροφή στην αρχική σελίδα</a></p>

<table width="1150" cellpadding="2" cellspacing="2" align="center" border="1">
    <thead>
        <tr class="style1">
            <th>#</th>
            <th>Ονοματεπώνυμο</th>
            <th>ΑΦΜ</th>
            <th>ΑΜΚΑ</th>
            <th>Αρ. Επιταγής</th>
            <th>Δωμάτιο</th>
            <th>Ημ. Άφιξης</th>
            <th>Ημ. Αναχώρησης</th>
            <th>Διανυκτερεύσεις</th>
            <th>Αρ. Ωφελ.</th>
            <th>Διαγραφή</th>
        </tr>
    </thead>
    <tbody>

<?php
$counter = 1;
while ($stmt->fetch()):
    $row_color = ($counter % 2 == 0) ? '#FFFFFF' : '#CCCCCC';
    $datein = date('d/m/Y', strtotime($date_in));
    $dateout = date('d/m/Y', strtotime($date_out));
?>
    <tr class="style1" style="background-color: <?= $row_color ?>;">
        <td><?= $counter++ ?></td>
        <td><a href="dik_cart.php?id=<?= $id ?>" title="εμφάνιση καρτέλας κράτησης"><?= htmlspecialchars($name) ?></a></td>
        <td align="center"><?= htmlspecialchars($afm) ?></td>
        <td  style="width: 100px; white-space: nowrap;" align="center"><?= htmlspecialchars($amka) ?></td>
        <td style="width: 200px; white-space: nowrap;" align="center"><?= htmlspecialchars($epitagi) ?></td>
        <td align="center"><?= htmlspecialchars($room) ?></td>
        <td align="center"><?= $datein ?></td>
        <td align="center"><?= $dateout ?></td>
        <td align="center"><?= htmlspecialchars($dianiktere) ?></td>
        <td align="center"><?= htmlspecialchars($ar_ofel) ?></td>
        <td align="center">
            <a href="oaed_del.php?id=<?= $id ?>">
                <img src="images/delete12.png" alt="del" height="12" width="12">
            </a>
        </td>
    </tr>
<?php endwhile; ?>
    </tbody>
</table>

</body>
</html>

<?php
$stmt->close();
$bd->close();
?>
