<?php
include('config.php');
include('lock.php');
include('welcome.php');
include('style.php');

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Μη έγκυρο ID.");
}

$kart = intval($_GET['id']);

$stmt = $bd->prepare("SELECT id, name, afm, amka, epitagi, room, date_in, date_out, dianiktere, ar_ofel FROM oaed_thea WHERE id = ?");
$stmt->bind_param('i', $kart);
$stmt->execute();
$stmt->bind_result($id, $name, $afm, $amka, $epitagi, $room, $date_in, $date_out, $dianiktere, $ar_ofel);

if (!$stmt->fetch()) {
    die("Δεν βρέθηκαν δεδομένα.");
}
$stmt->close();

// Υπολογισμοί
$date1 = new DateTime($date_in);
$date2 = new DateTime($date_out);
$diff = $date1->diff($date2)->days;

$atom = $ar_ofel + 1;

// Οι παρακάτω μεταβλητές πρέπει να οριστούν κατάλληλα ή να προστεθούν στο SELECT αν έρχονται από τη βάση
$epidotisi = 10;      // Παράδειγμα τιμή
$simetoxi = 5;        // Παράδειγμα τιμή
$simf_simetox = 15;   // Παράδειγμα τιμή
$apy_oaed = '';       // Αν δεν υπάρχει τιμή, να οριστεί κενή ή ανακτηθεί αλλού
$apy_pel = '';
$eggrafes = $atom;    // Ή ό,τι είναι σωστός αριθμός εγγραφών
$gr_ofel = $ar_ofel;  // Αντίγραφο για χρήση στον σύνδεσμο

$poso_apy_oaed = $epidotisi * $atom;
$poso_apy_pel = $simetoxi * $atom;
$simf = ($diff * $simf_simetox) * $atom;

$s_im = $simetoxi / $dianiktere;
$s_im_a = $simf_simetox - $s_im;
$simf_im = $s_im_a * $atom;

$poso_tamio = $simf - $poso_apy_pel;
$sin_xreosi = $poso_tamio + $poso_apy_oaed + $poso_apy_pel;
?>

<!DOCTYPE html>
<html lang="el">
<head>
    <meta charset="UTF-8">
    <title>Προβολή Πελάτη</title>
    <style>
        table { border-collapse: collapse; margin: 20px auto; width: 90%; background-color: #fff; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; font-family: Arial; }
        th { background-color: #f2f2f2; }
        .center { text-align: center; }
        .button { padding: 10px 15px; margin: 10px; font-weight: bold; }
    </style>
</head>
<body>

<div class="center">
    <input type="button" value="Αναίρεση" onclick="window.history.back()" class="button">
    <a href="home.php" class="button">Αρχική Σελίδα</a>
</div>

<h2 class="center">Προβολή Δεδομένων Πελάτη</h2>

<table>
    <tr>
        <th>Ονομ/νυμο</th>  <td><?= htmlspecialchars($name) ?></td>
        <th>ΑΦΜ</th>        <td><?= htmlspecialchars($afm)  ?></td>
        <th>ΑΜΚΑ</th>       <td><?= htmlspecialchars($amka) ?></td>
    </tr>
    <tr>
        <th>Άφιξη</th>       <td><?= date('d/m/Y', strtotime($date_in)) ?></td>
        <th>Αναχώρηση</th>   <td><?= date('d/m/Y', strtotime($date_out)) ?></td>
        <th>Διανυκτερεύσεις</th><td><?= $diff ?></td>
    </tr>
    <tr>
        <th>Αρ. Ωφελουμένων</th> <td><?= $ar_ofel ?></td>
        <th>Σύνολο ΑΠΥ ΟΑΕΔ</th> <td><?= number_format($poso_apy_oaed, 2) ?> €</td>
        <th>Σύνολο ΑΠΥ Πελάτη</th> <td><?= number_format($poso_apy_pel, 2) ?> €</td>
    </tr>
    <tr>
        <th>Τελική Χρέωση</th><td ><?= number_format($sin_xreosi, 2) ?> €</td>
        <th>ΑΠΥ ΟΑΕΔ (No)</th><td><?= $apy_oaed ?: 'Δεν υπάρχει' ?></td>
        <th>ΑΠΥ Πελάτη (No)</th><td><?= $apy_pel ?: 'Δεν υπάρχει' ?></td>
    </tr>
</table>

<table>
    <tr>  <td></td>
        <td><span class="style111">ΑΠΥ ΟΑΕΔ (No <?= $apy_oaed ?>)</span></td>
        <td></td>
        <td><span class="style111">ΑΠΥ πελάτη (No <?= $apy_pel ?>)</span></td>
    </tr>
    <tr>
        <td align="right">
            <a href="simb.php?id=<?= $id ?>"><img src="images/simb.jpg" title="Σύμβαση" style="width:50px;height:40px;" /></a>
            <a href="simb_2.php?id=<?= $id ?>"><img src="images/kartela.png" title="Χωρίς δικαιούχο" style="width:50px;height:40px;" /></a>
        </td>
        <td align="left"><a href="deltio_af.php?id=<?= $id ?>"><img src="images/afixi.jpg" title="Δελτίο Άφιξης" style="width:70px;height:40px;" /></a></td>
        <td align="left"><a href="add_apy.php?id=<?= $id ?>"><img src="images/kartela.png" title="Επιδότηση ΟΑΕΔ" style="width:50px;height:40px;" /></a></td>
        <td align="left"><a href="add_apy_p.php?id=<?= $id ?>"><img src="images/kartela.png" title="Συμμετοχή Πελάτη" style="width:50px;height:40px;" /></a></td>
    </tr>
    <tr>
        <td class="center">Προβολή PDF</td>
        <td><a href="upl.php?id=<?= $id ?>">Αποθήκευση PDF</a></td>
        <td><a href="pr_de.php?id=<?= $id ?>">Εκτύπωση επιταγής</a></td>
        <td colspan="2"><a href="add_ofe_edit.php?id=<?= $id ?>&ar_symb=<?= $id ?>">Νέος Ωφελούμενος</a></td>
        <td><a href="ofe_oaed.php?id=<?= $id ?>">Εμφάνιση Ωφελουμένων</a></td>
    </tr>

    <?php
    $stmtPDF = $bd->prepare("SELECT * FROM uploads WHERE dikaio = ?");
    $stmtPDF->bind_param('i', $kart);
    $stmtPDF->execute();
    $result = $stmtPDF->get_result();

    while ($row = $result->fetch_assoc()) {
        echo '<tr><td colspan="6" align="center"><a href="uploads/' . htmlspecialchars($row['file']) . '" target="_blank"><img src="images/pdf.png" style="width:30px;height:30px;" title="Προβολή PDF" /></a></td></tr>';
    }

    $stmtPDF->close();
    ?>

    <tr>
        <td colspan="6" align="center">
            <?php if ($atom != $eggrafes): ?>
                <span style="color:red;">
                    Δεν συμφωνούν οι ωφελούμενοι με τις εγγραφές. 
                    <a href="up_ofe.php?ar_symb=<?= $id ?>&ar_ofel=<?= $gr_ofel ?>&id=<?= $kart ?>">(klik εδώ για ενημέρωση)</a>
                </span>
            <?php endif; ?>
        </td>
    </tr>
</table>

</body>
</html>

<?php
$bd->close();
?>
