<?php
include('lock.php');
include('config.php');
include('style.php');
include('welcome.php');

// Έλεγχος αν το session έχει ήδη ξεκινήσει
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Προετοιμασία της σύνδεσης με τη βάση δεδομένων χρησιμοποιώντας PDO
try {
    $bd = new PDO("mysql:host=$host;dbname=$database", $user, $password);
    $bd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Για να καταλάβεις τα λάθη πιο εύκολα
} catch (PDOException $e) {
    die("Δεν ήταν δυνατή η σύνδεση με τη βάση δεδομένων: " . $e->getMessage());
}




// Ερώτημα για τα σύνολα
$stmtSum = $bd->prepare("SELECT SUM(epidotisi), SUM(simetoxi), SUM(dianiktere) FROM oaed_thea WHERE periodos = 'b'");
$stmtSum->execute();
$sumepid = $stmtSum->fetchColumn(0);
$sumsime = $stmtSum->fetchColumn(1);
$sumdiak = $stmtSum->fetchColumn(2);

// Ερώτημα για τα δεδομένα των δικαιούχων
$stmt = $bd->prepare("SELECT * FROM oaed_thea WHERE periodos = 'b' ORDER BY date_in ASC, id ASC");
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="el">
<head>
    <meta charset="UTF-8">
    <title>Πίνακας Δικαιούχων</title>
    <style>
        /* Προσαρμοσμένα στυλ */
        .style1 { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; font-weight: bold; color: #333; }
        .style7 { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 22px; font-weight: bold; color: #333; }
        .style4 { font-family: Geneva, Arial, Helvetica, sans-serif; font-size: 14px; font-weight: bold; }
        a { color: #19315E; text-decoration: none; }
        body { background-color: #FFFFFF; }
    </style>
</head>
<body>

<p align="center" class="style7">Πίνακας Δικαιούχων Β΄ Περιόδου 24-25</p>
<p align="center" class="style4"><a href="home.php">Επιστροφή στην αρχική σελίδα</a></p>

<table width="100%" cellpadding="2" cellspacing="2" align="center">
    <thead>
        <tr class="style1">
            <th>#</th>
            <th>Ονοματεπώνυμο</th>
            <th>ΑΦΜ</th>
            <th>ΑΜΚΑ</th>
            <th>Αρ. Επιταγής</th>
            <th>Δωμάτιο</th>
            <th>Ημ. Άφιξης</th>
            <th>Ημ. Αναχώρησης</th>
            <th>Διαν/σεις</th>
            <th>Επιδότηση</th>
            <th>Συμμετοχή</th>
             <th>edit</th>
            <th>delete</th>
        </tr>
    </thead>
    <tbody>

<?php
$counter = 1;
foreach ($results as $row) {
    $datein = date('d/m/Y', strtotime($row['date_in']));
    $dateout = date('d/m/Y', strtotime($row['date_out']));
    $rowColor = ($counter % 2 == 0) ? '#FFFFFF' : '#CCCCCC';
    ?>

    <tr class="style1" style="background-color: <?= $rowColor ?>">
        <td align="center"><?= $counter++ ?></td>
        <td  style="width: 180px; white-space: nowrap;" align="left"><?= htmlspecialchars($row['name']) ?></td>
        <td align="center"><?= htmlspecialchars($row['afm']) ?></td>
        <td  style="width: 100px; white-space: nowrap;" align="center"><?= htmlspecialchars($row['amka']) ?></td>
        <td  style="width: 200px; white-space: nowrap;" align="center"><?= htmlspecialchars($row['epitagi']) ?></td>
        <td align="center"><?= htmlspecialchars($row['room']) ?></td>
        <td align="center"><?= $datein ?></td>
        <td align="center"><?= $dateout ?></td>
        <td align="center"><?= htmlspecialchars($row['dianiktere']) ?></td>
        <td align="right"><?= htmlspecialchars($row['epidotisi']) ?></td>
        <td align="right"><?= htmlspecialchars($row['simetoxi']) ?></td>
        <td align="center">
            <a href="edit_dik.php?id=<?= $row['id'] ?>">edit</a>
        </td>
        <td align="center">
            <a href="oaed_del.php?id=<?= $row['id'] ?>"><img src="images/delete12.png" alt="delete" height="12" width="12"></a>
        </td>
    </tr>

<?php
}
?>

    <tr class="style1">
        <td colspan="8" align="right">Σύνολα</td>
        <td align="center" bgcolor="#CCCCCC"><?= $sumdiak ?></td>
        <td align="right" bgcolor="#CCCCCC"><?= $sumepid ?></td>
        <td align="right" bgcolor="#CCCCCC"><?= $sumsime ?></td>
    </tr>

    </tbody>
</table>

</body>
</html>

<?php
// Κλείσιμο σύνδεσης PDO
$bd = null;
?>