<?php
include('lock.php');
include('config.php');
include('style.php');
include('welcome.php');

$bd->set_charset("utf8");

echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';

?>

<style type="text/css">

</style>

<p align="center" class="style4"><a href="home.php">επιστροφή στην αρχική σελίδα</a></p>
<p>&nbsp;</p>
<div align="center" class="style39 style1">Αναζήτηση δικαιούχων</div>
<p><div align="center" class="style7 style2">(αναζήτηση με επώνυμο ή AMKA ή αρ. επιταγής)</div></p>

<!-- Φόρμα Αναζήτησης -->
<div align="center">
    <form action="<?= htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="GET">
        <input type="text" name="query" class="inputbox" placeholder="Εισάγετε το όνομα, ΑΜΚΑ ή επιταγή" />
        <input type="submit" value="Αναζήτηση" />
    </form>
</div>

<?php
if (isset($_GET['query']) && strlen(trim($_GET['query'])) > 0) {
    // Λήψη της τιμής της αναζήτησης
    $query = '%' . trim($_GET['query']) . '%';

    

    // Αρχικοποίηση του SQL query χωρίς το κριτήριο dik_ofel
    $sql = "SELECT id, name, afm, amka, epitagi, date_in 
            FROM oaed_thea 
            WHERE (name LIKE ? OR amka LIKE ? OR epitagi LIKE ?)";

    // Ετοιμάζουμε το SQL statement
    $stmt = $bd->prepare($sql);
    if (!$stmt) {
        die("Error preparing statement: " . $bd->error);
    }

    // Δεσμεύουμε τις παραμέτρους
    $stmt->bind_param("sss", $query, $query, $query);

    // Εκτέλεση του query και έλεγχος για αποτυχία
    $executeResult = $stmt->execute();
    if (!$executeResult) {
        die("Query execution failed: " . $bd->error);
    }

    // Αποθήκευση του αποτελέσματος
    $stmt->store_result();

    // Δέσμευση των στηλών
    $stmt->bind_result($id, $name, $afm, $amka, $epitagi, $date_in);

    // Εμφάνιση των αποτελεσμάτων
    if ($stmt->num_rows > 0) {
        echo '<table width="700" align="center" cellpadding="1" cellspacing="0" class="display" border="1" bordercolor="#333">';
        echo '<thead><tr>
                <th width="250" align="left"><span class="style2">&nbsp;Επώνυμο</span></th>
                <th width="80" align="center"><span class="style2">Άφιξη</span></th>
                <th width="100" align="center"><span class="style2">ΑΜΚΑ</span></th>
                <th width="300" align="center"><span class="style2">Επιταγή</span></th>
              </tr></thead>';

        $c = false; // Για την εναλλαγή χρωμάτων στις γραμμές του πίνακα
        while ($stmt->fetch()) {
            $datein = date('d/m/Y', strtotime($date_in));
            echo '<tr class="styleb" style="background:' . (($c = !$c) ? '#e9e9e9' : '#FFFF99') . '">';
            echo '<td align="left" style="font-size:12px;">
                    <a href="dik_cart.php?id=' . $id . '" title="εμφάνιση καρτέλας κράτησης">&nbsp;' . htmlspecialchars($name) . '</a></td>';
            echo '<td align="center" style="font-size:12px;">' . $datein . '</td>';
            echo '<td align="center" style="font-size:12px;">' . htmlspecialchars($amka) . '</td>';
            echo '<td align="center" style="font-size:12px;">' . htmlspecialchars($epitagi) . '</td>';
            echo '</tr>';
        }
        echo '</table>';
    } else {
        echo '<table width="460" align="center" cellpadding="0" cellspacing="0" class="display" border="0" bordercolor="#333">';
        echo '<tr class="styleb" style="background:#e9e9e9">';
        echo '<td align="center" colspan="4" bgcolor="#fff" style="font-size:15px; height:30px;"><font color="#900">Δεν βρέθηκαν εγγραφές</font></td>';
        echo '</tr></table>';
    }

    $stmt->close();
}
?>
